/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TicketUserOsInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserOsInterceptor.class);

    public TicketUserOsInterceptor() {
    }

    public TicketUserOsInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        int os = requestModel.getOs();
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            if (ticket.isSupportedOs(os)) continue;
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[TicketUserOsInterceptor] remove {}.", (Object)ticket.getId());
        }
    }
}

