/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter.times;

import com.bxm.adsprod.model.so.rules.TicketTimesRuleSo;
import com.bxm.adsprod.service.ticket.filter.times.EveryDayClickTimesRuleProcessor;
import com.bxm.adsprod.service.ticket.filter.times.EveryDayViewTimesRuleProcessor;
import com.bxm.adsprod.service.ticket.filter.times.EveryWeekClickTimesRuleProcessor;
import com.bxm.adsprod.service.ticket.filter.times.EveryWeekViewTimesRuleProcessor;
import com.bxm.adsprod.service.ticket.filter.times.TimesRuleProcessor;
import com.bxm.adsprod.service.user.UserStatisticsService;

public final class TimesRuleProcessorFactory {
    private TimesRuleProcessorFactory() {
    }

    public static TimesRuleProcessor create(UserStatisticsService userStatisticsService, TicketTimesRuleSo.Entry entry) {
        int cycle = entry.getCycle();
        int type = entry.getType();
        long max = entry.getCount();
        if (1 == cycle && 1 == type) {
            return new EveryDayViewTimesRuleProcessor(userStatisticsService, max);
        }
        if (1 == cycle && 2 == type) {
            return new EveryDayClickTimesRuleProcessor(userStatisticsService, max);
        }
        if (2 == cycle && 1 == type) {
            return new EveryWeekViewTimesRuleProcessor(userStatisticsService, max);
        }
        if (2 == cycle && 2 == type) {
            return new EveryWeekClickTimesRuleProcessor(userStatisticsService, max);
        }
        throw new UnsupportedOperationException();
    }
}

