/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.pushable;

import com.bxm.adsprod.common.pushable.annotation.CachePush;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketWeightMif;
import com.bxm.adsprod.service.ticket.pushable.TicketPricePushable;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.JSONArrayPushable;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="TICKET_MIF")
public class TicketMifPushable
extends JSONArrayPushable<TicketWeightMif> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPricePushable.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public TicketMifPushable() {
        super((Converter)new Converter<TicketWeightMif>(){

            public Object convert(TicketWeightMif object) {
                return new BigDecimal(object.getMif()).divide(new BigDecimal(100)).doubleValue();
            }
        });
    }

    protected Class<TicketWeightMif> getClsType() {
        return TicketWeightMif.class;
    }

    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters, TicketWeightMif object) {
        parameters.put("positionid", object.getPositionId());
        return TicketKeyGenerator.getTicketMif(parameters);
    }

    protected Updater getUpdater() {
        return this.updater;
    }
}

