/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.pushable;

import com.bxm.adsprod.common.pushable.annotation.CachePush;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketPrice;
import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.JSONArrayPushable;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="TICKET_PRICE")
public class TicketPricePushable
extends JSONArrayPushable<TicketPrice> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPricePushable.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    protected Class<TicketPrice> getClsType() {
        return TicketPrice.class;
    }

    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters, TicketPrice object) {
        parameters.put("positionid", object.getPositionId());
        return TicketKeyGenerator.getTicketPrice(parameters);
    }

    protected Updater getUpdater() {
        return this.updater;
    }

    protected void afterUpdated(Map<String, Object> parameters, final TicketPrice object) {
        parameters.put("positionid", object.getPositionId());
        Integer first = (Integer)this.fetcher.fetch(TicketKeyGenerator.getTicketPriceOfTodayFirst(parameters), (DataExtractor)new DataExtractor<Integer>(){

            public Integer extract() {
                return object.getBeforePrice();
            }
        }, Integer.class, TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday()).intValue());
        BigDecimal floatPercent = new BigDecimal(object.getAfterPrice()).divide(new BigDecimal(first)).multiply(new BigDecimal(100));
        int oneHour = 3600;
        this.updater.update(TicketKeyGenerator.getTicketPriceFloatPercent(parameters), (Object)floatPercent, oneHour);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting ad-inspectors price float percent\uff1aparameters={}, first price={}, float percent={}.", new Object[]{parameters, first, floatPercent});
        }
    }
}

