/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.pushable;

import com.bxm.adsprod.common.pushable.annotation.CachePush;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketProfitForCpa;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.HashUpdating;
import com.bxm.warcar.cache.push.JSONArrayPushable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="TICKET_PROFIT_FOR_CPA")
public class TicketProfitForCpaPushable
extends JSONArrayPushable<TicketProfitForCpa>
implements HashUpdating<TicketProfitForCpa> {
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public TicketProfitForCpaPushable() {
        super((Converter)new Converter<TicketProfitForCpa>(){

            public Object convert(TicketProfitForCpa object) {
                return object.getProfit();
            }
        });
    }

    public String getField(Map<String, Object> parameters, TicketProfitForCpa object) {
        return String.valueOf(object.getTicketId());
    }

    protected Class<TicketProfitForCpa> getClsType() {
        return TicketProfitForCpa.class;
    }

    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters, TicketProfitForCpa object) {
        String date = object.getDate();
        LocalDate localDate = LocalDate.parse(date, DateTimeFormatter.ofPattern(object.getDatePattern()));
        return TicketKeyGenerator.getTicketProfitForCpa((String)localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }

    protected Updater getUpdater() {
        return this.updater;
    }
}

