/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.statistics;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.facade.commons.MessageBody;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.MessageListener;
import com.bxm.warcar.mq.alions.AlionsConsumer;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageListener.class);

    protected abstract void consume(Message var1, Object var2, Object var3);

    public ConsumeStatus consume(List<Message> messages, Object context) {
        try {
            for (Message message : messages) {
                Object returning;
                MessageBody body = (MessageBody)JsonHelper.convert((byte[])message.getBody(), MessageBody.class);
                if (null == body) continue;
                Object request = body.getRequest();
                if (null != request && request instanceof JSON) {
                    request = JSONObject.toJavaObject((JSON)((JSON)request), (Class)body.getRequestClass());
                }
                if (null != (returning = body.getReturning()) && returning instanceof JSON) {
                    returning = JSONObject.toJavaObject((JSON)((JSON)body.getReturning()), (Class)body.getReturningClass());
                }
                this.consume(message, request, returning);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("[{}] - [{}] consume message: {}", new Object[]{Thread.currentThread(), this, message.getMsgId()});
            }
            return ConsumeStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("consume: ", (Throwable)e);
            }
            return ConsumeStatus.RECONSUME_LATER;
        }
    }

    protected Consumer createConsumer(String consumerId, String accessKey, String secretKey) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registering consumer: {} of top: {}", (Object)consumerId, (Object)this.getTopic());
        }
        return new AlionsConsumer(consumerId, accessKey, secretKey, this){

            @PostConstruct
            protected void doInit() {
                super.doInit();
            }

            @PreDestroy
            protected void doDestroy() {
                super.doDestroy();
            }
        };
    }
}

