/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.statistics.cashier;

import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.service.ticket.statistics.AbstractMessageListener;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import java.util.EventObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={AlionsConfiguration.class})
public class AdvertiserCashier
extends AbstractMessageListener {
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;
    @Autowired
    private AlionsConfiguration alionsConfiguration;
    @Autowired
    private EventPark eventPark;

    protected long getIncrementValue(ClickRequest request, Ticket ticket) {
        return -(ticket.isCPC() ? ticket.getPrice() : 0);
    }

    @Override
    protected void consume(Message message, Object request, Object returning) {
        this.consume((ClickRequest)request, (Ticket)returning);
    }

    protected void consume(ClickRequest request, Ticket ticket) {
        long incrementValue = this.getIncrementValue(request, ticket);
        this.increment(request.getUid(), ticket, incrementValue);
    }

    private void increment(String uid, Ticket ticket, long inc) {
        KeyGenerator keyGenerator = TicketKeyGenerator.Advertiser.getBalance();
        Long crtbalance = this.counter.hincrementByAndGet(keyGenerator, String.valueOf(ticket.getAdvertiser()), inc);
        if (null != crtbalance && crtbalance <= 0L) {
            this.eventPark.post((EventObject)new BalanceNotEnoughEvent(this, ticket));
        }
    }

    public String getTopic() {
        return "BXM_AD_CLICKTICKET";
    }

    @Bean
    public Consumer ticket1HourViewCounterConsumer() {
        return this.createConsumer("CID_BXM_ADVERTISER_CASHIER", this.alionsConfiguration.getAccessKey(), this.alionsConfiguration.getSecretKey());
    }
}

