/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.statistics.counter;

import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.ticket.statistics.AbstractMessageListener;
import com.bxm.adsprod.service.ticket.statistics.counter.Ticket60MinutesViewCounter;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
@EnableConfigurationProperties(value={AlionsConfiguration.class})
public class Ticket24HoursBudgetCounter
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ticket60MinutesViewCounter.class);
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private AlionsConfiguration alionsConfiguration;

    @Override
    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ClickRequest)request, (Ticket)returning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consume(Message message, ClickRequest request, Ticket ticket) {
        BigInteger ticketId = ticket.getId();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHH");
        String yyyyMMddHHmm = formatter.format(LocalDateTime.now());
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            String key = KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "BUDGET_24HOURS", yyyyMMddHHmm});
            Integer price = ticket.getPrice();
            if (null == price) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Ticket's price is null.");
                }
                return;
            }
            jedis.zincrby(key, (double)price.intValue(), String.valueOf(ticketId));
            jedis.expire(key, 86400);
        }
    }

    public String getTopic() {
        return "BXM_AD_CLICKTICKET";
    }

    @Bean
    public Consumer ticket24HoursBudgetCounterConsumer() {
        return this.createConsumer("CID_BXM_TICKET_24HOURS_BUDGET_COUNTER", this.alionsConfiguration.getAccessKey(), this.alionsConfiguration.getSecretKey());
    }
}

