/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.statistics.counter;

import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.statistics.AbstractViewCounter;
import com.bxm.adsprod.service.ticket.statistics.HashCounter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={AlionsConfiguration.class})
public class TicketDailyViewCounter
extends AbstractViewCounter
implements HashCounter {
    @Autowired
    private AlionsConfiguration configuration;

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getViewOfDaily();
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }

    @Bean
    public Consumer ticketDailyViewCounterConsumer() {
        return this.createConsumer("CID_BXM_TICKET_DAILY_VIEW_COUNTER", this.configuration.getAccessKey(), this.configuration.getSecretKey());
    }
}

