/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.statistics.recorder;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import com.bxm.adsprod.service.ticket.statistics.AbstractMessageListener;
import com.bxm.adsprod.service.user.UserService;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={AlionsConfiguration.class})
public class UserLastTicketRecorder
extends AbstractMessageListener {
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private AlionsConfiguration alionsConfiguration;
    @Autowired
    @Qualifier(value="userServiceImpl")
    private UserService userService;

    protected void consume(Message message, TicketRequest request, Ticket ticket) {
        this.userService.setLastAcquireTicket(ticket, request.getUid());
    }

    @Override
    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (TicketRequest)request, (Ticket)returning);
    }

    public String getTopic() {
        return "BXM_AD_VIEWTICKET";
    }

    @Bean
    public Consumer userLastTicketRecoderConsumer() {
        return this.createConsumer("CID_BXM_TICKET_USER_LAST_RECORDER", this.alionsConfiguration.getAccessKey(), this.alionsConfiguration.getSecretKey());
    }
}

