/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.user.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @Override
    public Ticket getLastAcquiredTicket(String uid) {
        return (Ticket)this.fetcher.fetch(this.keyGenerator(uid), null, Ticket.class);
    }

    @Override
    public void setLastAcquireTicket(Ticket ticket, String uid) {
        if (null == ticket) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("inspectors is null.");
            }
            return;
        }
        if (StringUtils.isBlank((String)uid)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("uid is null.");
            }
            return;
        }
        this.updater.update(this.keyGenerator(uid), (Object)ticket, TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday()).intValue());
    }

    private KeyGenerator keyGenerator(final String uid) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "RECORD", "LAST", uid});
            }
        };
    }
}

