/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.user.UserStatisticsService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UserStatisticsServiceImpl
implements UserStatisticsService {
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;

    @Override
    public long countViewOfToday(String uid, BigInteger ticketId) {
        KeyGenerator viewOfDaily = TicketKeyGenerator.Statistics.getViewOfDaily((BigInteger)ticketId);
        Long count = this.counter.hget(viewOfDaily, uid);
        return this.getLongIgnoreNull(count);
    }

    @Override
    public long countClickOfToday(String uid, BigInteger ticketId) {
        KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getClickOfDaily((BigInteger)ticketId);
        Long count = this.counter.hget(clickOfDaily, uid);
        return this.getLongIgnoreNull(count);
    }

    @Override
    public long countViewOfThisWeek(String uid, BigInteger ticketId) {
        KeyGenerator viewOfWeekly = TicketKeyGenerator.Statistics.getViewOfWeekly((BigInteger)ticketId);
        Long count = this.counter.hget(viewOfWeekly, uid);
        return this.getLongIgnoreNull(count);
    }

    @Override
    public long countClickOfThisWeek(String uid, BigInteger ticketId) {
        KeyGenerator clickOfWeekly = TicketKeyGenerator.Statistics.getClickOfWeekly((BigInteger)ticketId);
        Long count = this.counter.hget(clickOfWeekly, uid);
        return this.getLongIgnoreNull(count);
    }

    private long getLongIgnoreNull(Long count) {
        return null == count ? 0L : count;
    }
}

