package com.bxm.adsprod.timer;

import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import com.bxm.warcar.integration.autoconfigure.distributed.EnableDistributedScheduling;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * <h3>广告券定时任务系统</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/14
 */
@SpringBootApplication
@EnableDiscoveryClient
@EnableDistributedScheduling
@MapperScan("com.bxm.adsprod.dal")
@EnableFeignClients({
        "com.bxm.adsprod.timer.integration",
        "com.bxm.adsprod.facade"
})
public class AdsProdTimerApplication implements SchedulingConfigurer {

    @Value("${scheduling.thread.pool.size}")
    private int schedulingThreadPoolSize;

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(AdsProdTimerApplication.class);
        application.addListeners(new SpringBootEnvironmentListener());
        application.run(args);
    }

    @Override
    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler(taskScheduler());
    }

    public Executor taskScheduler() {
        return new ScheduledThreadPoolExecutor(schedulingThreadPoolSize, new NamedThreadFactory("timer"));
    }
}
