package com.bxm.adsprod.timer.integration.app;


import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class AppEntranceAdRO implements Serializable {

    private static final long serialVersionUID = 3828462066995272100L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 媒体ID
     * 媒体系统类型
     * 媒体类型ID
     * 媒体类型名称
     * 媒体子分类ID
     * 媒体子类型名称
     */
    private Long mediaId;
    private String mediaSysType;
    private Long mediaClassId;
    private String mediaClassName;
    private Long mediaChildClassId;
    private String mediaChildClassName;

    /**
     * 开发者ID
     * 开发者的别名
     * 开发者的app_key
     * 开发者注册时间
     * 媒介code
     * 商务code
     */
    private Long providerId;
    private String providerAlias;
    private String appKey;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date providerCreateTime;
    private String mjCode;
    private String bdCode;

    /**
     * app入口id
     * app入口名称
     * 广告位别名
     * 广告位id标识
     * 入口场景（就等于素材类型）
     * 入口场景图片地址
     */
    private Long appEntranceId;
    private String appEntranceName;
    private String alias;
    private String positionId;
    private String entranceScene;
    private String entrancePicUrl;


    /**
     * 对接方式：0获取链接,1JS对接,2API对接，默认0
     * 素材图片尺寸
     * 是否是DSP
     */
    private Byte dockingMethod;
    private String imageSize;
    private Boolean dspFlag;

    /**
     * 广告位状态：0审核中,1已通过,2已拒绝，默认0
     * 审核不通过原因
     */
    private Byte status;
    private String refuseReason;

    /**
     * 创建人
     * 修改人
     * 创建时间
     * 修改时间
     */
    private Long creator;
    private String modifier;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifiedTime;

    /**
     * 是否删除（逻辑删除）y:是，n:否
     * 是否已关闭 T/F
     */
    private Boolean deletedFlag;
    private Boolean closedFlag;

    /**
     * 上线时间
     * 备注
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date onlineTime;
    private String remark;


    /**
     * 券码投放?0:关闭，1:开启 ？true开启， false 关闭
     */
    private Boolean couponsPutinFlag;

    /**
     * 券码投放浮标位尺寸ID
     */
    private Long couponsIconSize;
    /**
     * 券码投放展示位尺寸ID
     */
    private Long couponsCreativeSize;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getMediaSysType() {
        return mediaSysType;
    }

    public void setMediaSysType(String mediaSysType) {
        this.mediaSysType = mediaSysType;
    }

    public Long getMediaClassId() {
        return mediaClassId;
    }

    public void setMediaClassId(Long mediaClassId) {
        this.mediaClassId = mediaClassId;
    }

    public Long getMediaChildClassId() {
        return mediaChildClassId;
    }

    public void setMediaChildClassId(Long mediaChildClassId) {
        this.mediaChildClassId = mediaChildClassId;
    }

    public Long getProviderId() {
        return providerId;
    }

    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }

    public String getProviderAlias() {
        return providerAlias;
    }

    public void setProviderAlias(String providerAlias) {
        this.providerAlias = providerAlias;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Date getProviderCreateTime() {
        return providerCreateTime;
    }

    public void setProviderCreateTime(Date providerCreateTime) {
        this.providerCreateTime = providerCreateTime;
    }

    public String getMjCode() {
        return mjCode;
    }

    public void setMjCode(String mjCode) {
        this.mjCode = mjCode;
    }

    public String getBdCode() {
        return bdCode;
    }

    public void setBdCode(String bdCode) {
        this.bdCode = bdCode;
    }

    public Long getAppEntranceId() {
        return appEntranceId;
    }

    public void setAppEntranceId(Long appEntranceId) {
        this.appEntranceId = appEntranceId;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getEntranceScene() {
        return entranceScene;
    }

    public void setEntranceScene(String entranceScene) {
        this.entranceScene = entranceScene;
    }

    public String getEntrancePicUrl() {
        return entrancePicUrl;
    }

    public void setEntrancePicUrl(String entrancePicUrl) {
        this.entrancePicUrl = entrancePicUrl;
    }

    public Byte getDockingMethod() {
        return dockingMethod;
    }

    public void setDockingMethod(Byte dockingMethod) {
        this.dockingMethod = dockingMethod;
    }

    public String getImageSize() {
        return imageSize;
    }

    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    public Boolean getDspFlag() {
        return dspFlag;
    }

    public void setDspFlag(Boolean dspFlag) {
        this.dspFlag = dspFlag;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getModifiedTime() {
        return modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public Boolean getDeletedFlag() {
        return deletedFlag;
    }

    public void setDeletedFlag(Boolean deletedFlag) {
        this.deletedFlag = deletedFlag;
    }

    public Boolean getClosedFlag() {
        return closedFlag;
    }

    public void setClosedFlag(Boolean closedFlag) {
        this.closedFlag = closedFlag;
    }

    public Date getOnlineTime() {
        return onlineTime;
    }

    public void setOnlineTime(Date onlineTime) {
        this.onlineTime = onlineTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getMediaClassName() {
        return mediaClassName;
    }

    public void setMediaClassName(String mediaClassName) {
        this.mediaClassName = mediaClassName;
    }

    public String getMediaChildClassName() {
        return mediaChildClassName;
    }

    public void setMediaChildClassName(String mediaChildClassName) {
        this.mediaChildClassName = mediaChildClassName;
    }

    public Boolean getCouponsPutinFlag() {
        return couponsPutinFlag;
    }

    public void setCouponsPutinFlag(Boolean couponsPutinFlag) {
        this.couponsPutinFlag = couponsPutinFlag;
    }

    public Long getCouponsIconSize() {
        return couponsIconSize;
    }

    public void setCouponsIconSize(Long couponsIconSize) {
        this.couponsIconSize = couponsIconSize;
    }

    public Long getCouponsCreativeSize() {
        return couponsCreativeSize;
    }

    public void setCouponsCreativeSize(Long couponsCreativeSize) {
        this.couponsCreativeSize = couponsCreativeSize;
    }
}
