package com.bxm.adsprod.timer.integration.app;



import com.bxm.warcar.utils.response.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
* @Title:AppEntranceFacadeIntegration.java
* @Package:com.bxm.activities.integration.app
* @Description: app服务广告位相关公共类
 */
@Component
public class AppEntranceFacadeIntegration {
    
    private static final Logger log = Logger.getLogger(AppEntranceFacadeIntegration.class);
    
    @Autowired
    private AppEntranceFacadeService appEntranceFacadeService;
    
    /**
    * @Title: getAllListByParam  
    * @Description: 查询广告平台的所有广告位信息
    * @param  paramDTO QueryAppEntranceParamDTO
    * @return List<AppEntranceAdRo> 
     */
    public List<AppEntranceAdRO> getAllListByParam(QueryAppEntranceParamDTO paramDTO) {
        if(paramDTO == null){
            paramDTO = new QueryAppEntranceParamDTO();
        }
        paramDTO.setStatus(null);
        paramDTO.setPageNum(1);
        paramDTO.setPageSize(Integer.MAX_VALUE);
        ResultModel<List<AppEntranceAdRO>> resultModel = null;
        try {
            resultModel = appEntranceFacadeService.getList(paramDTO);
            if (resultModel != null && resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
        } catch (Exception e) {
            log.error("调用APP通用接口查询广告位集合异常！" + e.getMessage(), e);
        }
        return Collections.emptyList();
    }

}
