package com.bxm.adsprod.timer.integration.app;

import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * app服务
 */
@FeignClient(name = "adsmedia")
public interface AppEntranceFacadeService {

    /**
     * Description: 查询广告位列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/24 15:49
     *
     * @param dto 查询条件
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRo>>
     * @author hxpeng
     */
    @RequestMapping(value = "/facade/appEntrance/getList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<List<AppEntranceAdRO>> getList(@RequestBody QueryAppEntranceParamDTO dto);


}
