package com.bxm.adsprod.timer.integration.app;

import java.io.Serializable;
import java.util.List;

/**
 * Description 查询广告位参数
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/24 15:43
 */
public class QueryAppEntranceParamDTO implements Serializable {

    private static final long serialVersionUID = 7409495753634009663L;
    /**
     * 广告位状态(构造器默认赋值state = 1，查询审核过的)
     * state = '', 0：审核中，1：已通过，2：已拒绝
     */
    private Byte status;

    /**
     * APPKEY
     * app_key = ''
     */
    private String appKey;
    /**
     * 模糊 appKey
     * app_key like ''
     */
    private String fuzzyAppKey;

    /**
     * 应用名称
     * app_name = ''
     */
    private String providerName;
    /**
     * 模糊 媒体名称
     * app_key like ''
     */
    private String fuzzyProviderName;

    /**
     * 广告位名称
     * app_entrance_name = ''
     */
    private String appEntranceName;

    /**
     * 广告位名称 模糊
     * app_entrance_name like ''
     */
    private String fuzzyAppEntranceName;

    /**
     * 根据appKey or appName 模糊查询
     * (app_key like '' or app_name like '')
     */
    private String appKeyOrProviderNameKeywords;

    /**
     * 根据appKey or appEntranceName 模糊查询
     * (app_key = '' or app_entrance_name like '')
     */
    private String appKeyOrFuzzyAppEntranceNameKeywords;

    /**
     * 根据positionId 和 appEntranceName模糊查询
     * (position_id = '' or app_entrance_name like '')
     */
    private String positionIdOrFuzzyAppEntranceNameKeywords;

    /**
     * 根据媒体名称 或 ID 模糊查询
     * (app_entrance_id = '' or app_entrance_name like '')
     */
    private String keywords;

    /**
     * 媒介
     * medium = ""
     */
    private String mjCode;

    /**
     * 上线时间范围查询--开始
     */
    private String onlineTimeStart;

    /**
     * 上线时间范围查询--结束
     */
    private String onlineTimeEnd;

    /**
     * 主键
     * id in ()
     */
    private List<Long> ids;

    /**
     * 主键
     * id not in ()
     */
    private List<Long> notInIds;

    /**
     * 广告位ID
     * position_id in ()
     */
    private List<String> positionIds;

    /**
     * appKey 集合
     * app_key in ()
     */
    private List<String> appKeys;

    /**
     * appEntranceId 集合
     * app_entrance_id in ()
     */
    private List<String> appEntranceIds;

    /**
     * 媒体系统类型code
     */
    private String mediaSysType;

    /**
     * 媒体分类ID
     */
    private Long mediaClassId;

    /**
     * 媒体子分类ID
     */
    private Long mediaChildClassId;

    /**
     * 分页
     */
    private Integer pageNum;
    private Integer pageSize;

    /**
     * 排序
     */
    private String sortField;
    private String orderType;

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getFuzzyAppKey() {
        return fuzzyAppKey;
    }

    public void setFuzzyAppKey(String fuzzyAppKey) {
        this.fuzzyAppKey = fuzzyAppKey;
    }

    public String getProviderName() {
        return providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getFuzzyProviderName() {
        return fuzzyProviderName;
    }

    public void setFuzzyProviderName(String fuzzyProviderName) {
        this.fuzzyProviderName = fuzzyProviderName;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public String getFuzzyAppEntranceName() {
        return fuzzyAppEntranceName;
    }

    public void setFuzzyAppEntranceName(String fuzzyAppEntranceName) {
        this.fuzzyAppEntranceName = fuzzyAppEntranceName;
    }

    public String getAppKeyOrProviderNameKeywords() {
        return appKeyOrProviderNameKeywords;
    }

    public void setAppKeyOrProviderNameKeywords(String appKeyOrProviderNameKeywords) {
        this.appKeyOrProviderNameKeywords = appKeyOrProviderNameKeywords;
    }

    public String getAppKeyOrFuzzyAppEntranceNameKeywords() {
        return appKeyOrFuzzyAppEntranceNameKeywords;
    }

    public void setAppKeyOrFuzzyAppEntranceNameKeywords(String appKeyOrFuzzyAppEntranceNameKeywords) {
        this.appKeyOrFuzzyAppEntranceNameKeywords = appKeyOrFuzzyAppEntranceNameKeywords;
    }

    public String getPositionIdOrFuzzyAppEntranceNameKeywords() {
        return positionIdOrFuzzyAppEntranceNameKeywords;
    }

    public void setPositionIdOrFuzzyAppEntranceNameKeywords(String positionIdOrFuzzyAppEntranceNameKeywords) {
        this.positionIdOrFuzzyAppEntranceNameKeywords = positionIdOrFuzzyAppEntranceNameKeywords;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getMjCode() {
        return mjCode;
    }

    public void setMjCode(String mjCode) {
        this.mjCode = mjCode;
    }

    public String getOnlineTimeStart() {
        return onlineTimeStart;
    }

    public void setOnlineTimeStart(String onlineTimeStart) {
        this.onlineTimeStart = onlineTimeStart;
    }

    public String getOnlineTimeEnd() {
        return onlineTimeEnd;
    }

    public void setOnlineTimeEnd(String onlineTimeEnd) {
        this.onlineTimeEnd = onlineTimeEnd;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public List<Long> getNotInIds() {
        return notInIds;
    }

    public void setNotInIds(List<Long> notInIds) {
        this.notInIds = notInIds;
    }

    public List<String> getPositionIds() {
        return positionIds;
    }

    public void setPositionIds(List<String> positionIds) {
        this.positionIds = positionIds;
    }

    public List<String> getAppKeys() {
        return appKeys;
    }

    public void setAppKeys(List<String> appKeys) {
        this.appKeys = appKeys;
    }

    public List<String> getAppEntranceIds() {
        return appEntranceIds;
    }

    public void setAppEntranceIds(List<String> appEntranceIds) {
        this.appEntranceIds = appEntranceIds;
    }

    public String getMediaSysType() {
        return mediaSysType;
    }

    public void setMediaSysType(String mediaSysType) {
        this.mediaSysType = mediaSysType;
    }

    public Long getMediaClassId() {
        return mediaClassId;
    }

    public void setMediaClassId(Long mediaClassId) {
        this.mediaClassId = mediaClassId;
    }

    public Long getMediaChildClassId() {
        return mediaChildClassId;
    }

    public void setMediaChildClassId(Long mediaChildClassId) {
        this.mediaChildClassId = mediaChildClassId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public QueryAppEntranceParamDTO() {
        this.pageNum = 1;
        this.pageSize = 10;
        this.status = 1;
        this.sortField = "id";
        this.orderType = "desc";
    }
}
