package com.bxm.adsprod.timer.jobs;

import com.bxm.adsprod.facade.ticket.TicketCouponLock;
import com.bxm.adsprod.facade.ticket.TicketCouponsCode;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.timer.Job;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * <h3>广告票券码解锁</h3>
 *
 * @author kerry.jiang
 * @date 2019/5/30 13:49
 */
@Component
public class TicketCouponUnlockJob implements Job {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketCouponUnlockJob.class);
    private static final long LIMIT_TIMES = 2 * 60 * 60 * 1000L;//2小时过期

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Override
    public void execute() {
        long start = System.currentTimeMillis();

        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting Unlocking coupon code...");
        }
        String likeLockKey = TicketKeyGenerator.Coupon.getCouponInfo(new BigInteger("-999"),
                TicketCouponsCode.AdCouponsStatus.TEMP_LOCK.getStatus()).generateKey().replace("-999", "*");
        String rep_lock = KeyBuilder.build("TYPE", TicketCouponsCode.AdCouponsStatus.TEMP_LOCK.getStatus());
        String rep_unused = KeyBuilder.build("TYPE", TicketCouponsCode.AdCouponsStatus.STATUS_UNUSED.getStatus());
        JedisPool jedisPool = (JedisPool)fetcher.getClientOriginal();
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Set<String> lockKeys = jedis.keys(likeLockKey);
            if(CollectionUtils.isEmpty(lockKeys)){
                //没有带锁定码的广告票券
                return ;
            }
            long nowTimes = new Date().getTime() - LIMIT_TIMES;//过期界限
            JSONSerialization serialization = new JSONSerialization();
            Set<String> keySet = null;
            for (String lockKey : lockKeys){
                Map<String, String> lockMap = jedis.hgetAll(lockKey);
                keySet = lockMap.keySet();
                for (String imei : keySet){//遍历锁码信息
                    String value = lockMap.get(imei);
                    TicketCouponLock lockInfo = serialization.deserialize(value, TicketCouponLock.class);
                    if(nowTimes < lockInfo.getLock_time().getTime()){//未过期
                        continue;
                    }
                    //处理已过期
                    if(jedis.hdel(lockKey, imei) > 0){
                        String unusedKey = lockKey.replaceAll(rep_lock, rep_unused);
                        jedis.sadd(unusedKey, lockInfo.getCoupons_code());
                    }
                }
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Finished in {} ms", (System.currentTimeMillis() - start));
            }
        }
    }
}
