package com.bxm.adsprod.timer.jobs.manual;

import com.bxm.adsprod.timer.jobs.DirectMaterialCTRJob;
import com.bxm.adsprod.timer.jobs.PositionDataPullJob;
import com.bxm.adsprod.timer.jobs.TicketCouponUnlockJob;
import com.bxm.adsprod.timer.jobs.TicketStatusRefreshJob;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 手工触发定时任务执行
 *
 * @author
 */
@RestController
@RequestMapping("/manual")
public class ManualController {

    @Autowired
    private DirectMaterialCTRJob directMaterialCTRJob;

    @Autowired
    private TicketStatusRefreshJob ticketStatusRefreshJob;

    @Autowired
    private PositionDataPullJob positionDataPullJob;

    @Autowired
    private TicketCouponUnlockJob ticketCouponUnlockJob;

    @RequestMapping("/materialCtr")
    public ResultModel materialCtr() {
        directMaterialCTRJob.execute();
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping("/statusRefresh")
    public ResultModel statusRefresh() {
        ticketStatusRefreshJob.execute();
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping("/updatePositionData")
    public ResultModel updatePositionData() {
        positionDataPullJob.execute();
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping("/unlockTicketCouponCode")
    public ResultModel unlockTicketCouponCode() {
        ticketCouponUnlockJob.execute();
        return ResultModelFactory.SUCCESS();
    }
}
