package com.bxm.adsprod.timer.utils;

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.bxm.adsprod.model.dao.media.PositionDao;
import com.bxm.adsprod.timer.integration.app.AppEntranceAdRO;
import com.google.common.collect.Lists;

/**
* @Title:AppEntityConvertHelper.java
* @Package:com.bxm.adsprod.integration.app
* @Description: 媒体相关
* @date:2018年12月5日 下午5:14:47
 */
public class AppEntityConvertHelper {
    
    //List<AppEntranceAdRo>转List<PositionDao>
    public static List<PositionDao> convertAppEntranceToPositionDaoList(List<AppEntranceAdRO> appEntranceAdRos) {
        if (CollectionUtils.isNotEmpty(appEntranceAdRos)) {
            List<PositionDao> positionDaoList = Lists.newArrayListWithCapacity(appEntranceAdRos.size());
            PositionDao positionDao = null;
            for (AppEntranceAdRO appEntranceAdRo : appEntranceAdRos) {
                positionDao = new PositionDao();
                String positionName = StringUtils.defaultString(appEntranceAdRo.getAlias(), appEntranceAdRo.getProviderAlias())
                        + appEntranceAdRo.getAppEntranceName();
                //广告位ID
                positionDao.setPositionId(appEntranceAdRo.getPositionId());
                //媒体名称-广告位名称
                positionDao.setPositionName(positionName);

                //券码投放?0:关闭，1:开启 ？true开启， false 关闭
                positionDao.setCouponsPutinFlag(appEntranceAdRo.getCouponsPutinFlag());
                //券码投放浮标位尺寸ID
                positionDao.setCouponsIconSize(appEntranceAdRo.getCouponsIconSize());
                //券码投放展示位尺寸ID
                positionDao.setCouponsCreativeSize(appEntranceAdRo.getCouponsCreativeSize());

                positionDaoList.add(positionDao);
            }
            return positionDaoList;
        }
        return Collections.emptyList();
    }
}
