/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.app.facade;

import com.bxm.app.model.dto.ProviderAppAdDto;
import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @ClassName ProviderAppFacadeService.java
 * @Description 功能描述：app
 * @author leon 2017年10月19日 下午5:23:18
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "app")
public interface ProviderAppFacadeService {

    /**
     * @Description 方法描述：修改app，修改开发者广告相关信息
     * @author leon 2018年3月12日 下午4:19:53
     * @CopyRight 杭州微财网络科技有限公司
     * @param providerAppAdDto
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/providerAppFacade/updateProviderAppAdInfo", method = RequestMethod.PUT)
    public ResultModel<Boolean> updateProviderAppAdInfo(@RequestBody ProviderAppAdDto providerAppAdDto) throws ValidateException,
                                                                                                        Exception;

    /**
     * @Description 方法描述：根据appId获取app详细信息：返回开发者名称，BD,媒介,备注
     * @author leon 2018年3月12日 下午4:19:33
     * @CopyRight 杭州微财网络科技有限公司
     * @param id
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/providerAppFacade/getById", method = RequestMethod.GET)
    public ResultModel<ProviderAppAdRo> getById(@RequestParam(value = "id", required = true) Long id) throws ValidateException,
                                                                                                      Exception;

    /**
     * @Description 方法描述：根据关键字查询app列表
     * @author leon 2018年3月12日 下午4:18:29
     * @CopyRight 杭州微财网络科技有限公司
     * @param keywords 关键字：appName,别名,媒介,备注
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/providerAppFacade/getList", method = RequestMethod.GET)
    public ResultModel<List<ProviderAppAdRo>> getList(@RequestParam(value = "keywords", required = false) String keywords) throws ValidateException,Exception;

    /**
     * @description: 根据帐户的预付类型查询app列表
     * @author: JandMin
     * @time: 2018/6/13 9:42
     * @param advanceType 预付类型：0 非预付; 1 预付
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.app.model.ro.ProviderAppAdRo>>
     */
    @RequestMapping(value = "/providerAppFacade/getListByAdvanceType", method = RequestMethod.GET)
    public ResultModel<List<ProviderAppAdRo>> getListByAdvanceType(@RequestParam(value = "advanceType", required = false)Integer advanceType, @RequestParam(value = "keywords", required = false) String keywords) throws Exception;


    /**
    * 根据审核状态为非正常状态找到appKey
    * @CopyRright  (c) 2018-微财科技有限公司
    * @author sunzhongshu
    * @created 2018/6/11 11:53
    * @modifier sunzhongshu
    */
    @RequestMapping(value = "/providerAppFacade/getProviderByState", method = RequestMethod.GET)
    public ResultModel<List<String>> getProviderByState() throws ValidateException,Exception;

    /**
     * 根据邮箱查询appky
     * 邮箱精确匹配
     * @CopyRright  (c) 2018-微财科技有限公司
     * @author bcc
     * @time 2018/07/18 19:35
     * @param email
     * @return
     */
    @RequestMapping(value = "/providerAppFacade/getAppkeyByEmail", method = RequestMethod.GET)
    public ResultModel<List<String>> getAppkeyByEmail(@RequestParam(value = "email", required = true) String email);
}
