package com.bxm.dailyegg.task.config;

import com.bxm.dailyegg.task.model.dto.TaskConfigDTO;
import com.bxm.newidea.component.JSONArray;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author lowi
 * @date 2022/2/22 11:03
 */
@Component
@ConfigurationPropertiesBinding
public class StringToTaskConfigConverter implements Converter<String, List<TaskConfigDTO>> {

    @Override
    public List<TaskConfigDTO> convert(String source) {
        if (StringUtils.isBlank(source)) {
            return Lists.newArrayList();
        }
        return JSONArray.parseArray(source, TaskConfigDTO.class);
    }
}
