package com.bxm.dailyegg.task.config;

import com.bxm.dailyegg.task.model.dto.TaskConfigDTO;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author lowi
 * @date 2022/2/21 19:36
 */
@ConfigurationProperties(prefix = "task.config")
@Data
@Component
public class TaskProperties {
    /**
     * 用户额外完成任务奖励信息
     */
    private Map<String, Integer> extFinishTaskReward;

    /**
     * 任务配置
     *
     * @deprecated 修改为使用 {@link #configMap}
     */
    private List<TaskConfigDTO> taskConfigDTO;

    /**
     * 新人引导任务的奖励粮食数量
     */
    private int guideAwardNum = 50;

    /**
     * 用户每日可完成的气泡任务的上限
     */
    private int maxBubbleTaskNum = 15;

    /**
     * 2.0.0 每次返回的气泡数量上限
     */
    private int bubbleTaskShowNum = 4;

    /**
     * 2.0.0 用户每日最多可以免费领取的气泡
     */
    private int maxFreeBubble = 10;

    private String freeBubbleIconUrl = "https://m.ningbojisheng.cn/daily-egg/png/grain.png";

    private String videoBubbleIconUrl = "https://m.ningbojisheng.cn/daily-egg/png/box.png";

    /**
     * 2.0.0 用户每日最多可看视频的气泡
     */
    private int maxVideoBubble = 10;

    /**
     * 任务奖励配置 V1.4.0以上
     */
    private Map<String, List<TaskAwardConfig>> configMap = Maps.newHashMap();

    @Data
    public static class TaskAwardConfig {

        private TaskAwardRange range;

        /**
         * 配置生效的版本,向下兼容,如果为空则全匹配
         * 暂时没做处理
         */
        private String matchVersion;

        /**
         * 奖励的粮食数量
         */
        private Integer awardNum;
    }

    @Data
    public static class TaskAwardRange {

        private Integer min = Integer.MIN_VALUE;

        private Integer max = Integer.MAX_VALUE;

        public boolean match(Integer totalFoods) {
            return totalFoods >= min && totalFoods < max;
        }
    }

    private Map<String, TaskConfigV3> taskConfigV3Map = Maps.newHashMap();

    @Data
    public static class TaskConfigV3 {
        /**
         * 最多完成次数
         */
        private Integer max;

        /**
         * 手动领取
         */
        private Boolean manual;

        /**
         * 任务显示排序
         */
        private Integer order;
    }
}
