package com.bxm.dailyegg.task.constant;

import com.bxm.dailyegg.task.service.filter.*;
import com.google.common.collect.Maps;
import lombok.experimental.UtilityClass;

import java.util.Map;

@UtilityClass
public class LogicConstant {

    /**
     * 用户任务列表过滤器处理
     */
    public static final String USER_TASK_FILTER = "USER_TASK_FILTER";

    private static Map<Class<?>, Integer> orderMap;

    static {
        orderMap = Maps.newHashMap();

        int index = 0;

        // 邀请逻辑排序
        orderMap.put(InitCacheTaskFilter.class, index++);

        orderMap.put(SignTaskFilter.class, index++);
        orderMap.put(VideoTaskFilter.class, index++);
        orderMap.put(JoinLotteryTaskFilter.class, index++);
        orderMap.put(PickEggTaskFilter.class, index++);
        orderMap.put(PickGrainTaskFilter.class, index++);
        orderMap.put(SpeedUpTaskFilter.class, index++);

    }

    public static Integer getOrder(Class<?> klass) {
        return orderMap.getOrDefault(klass, 0);
    }
}
