package com.bxm.dailyegg.task.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * @author lowi
 * @date 2022/2/21 15:49
 */
public class RedisCacheConstant {

    private static KeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("daily-egg");

    public static KeyGenerator DAILY_TASK_LIST = BASE_KEY.copy().setGroup("task").setKey("dailyTask");

    public static KeyGenerator BUBBLE_TASK_LIST = BASE_KEY.copy().setGroup("task").setKey("bubbleTask");

    /**
     * 用户日常任务次数
     */
    public static KeyGenerator USER_DAILY_TASK_NUM = BASE_KEY.copy().setGroup("user").setKey("dailyTaskNum");

    /**
     * 用户气泡任务次数
     */
    public static KeyGenerator USER_BUBBLE_TASK_NUM = BASE_KEY.copy().setGroup("user").setKey("bubbleTaskNum");

    /**
     * 用户当天任务完成信息
     */
    public static KeyGenerator USER_DAILY_TASK_FINISH_INFO = BASE_KEY.copy()
                                                                     .setGroup("user")
                                                                     .setKey("dailyTaskFinishInfo");

    /**
     * 用户获取额外奖励次数
     */
    public static KeyGenerator USER_EXT_REWARD_NUM = BASE_KEY.copy().setGroup("user").setKey("extRewardNum");

    /**
     * 用户当天签到
     */
    public static KeyGenerator USER_CURR_SIGN_INFO = BASE_KEY.copy().setGroup("user").setKey("currSign");

    /**
     * 用户打开app时间间隔
     */
    public static KeyGenerator USER_OPEN_APP_TIME = BASE_KEY.copy().setGroup("user").setKey("openAppTime");

    /**
     * 用户是否完成过新手引导视频任务
     */
    public static KeyGenerator USER_GUIDE_AWARD_CACHE = BASE_KEY.copy()
                                                                .setGroup("task")
                                                                .setKey("cache")
                                                                .appendKey("guide");

    /**
     * 用户气泡任务
     */
    public static KeyGenerator USER_BUBBLE_TASK_CACHE = BASE_KEY.copy()
                                                                .setGroup("task")
                                                                .setKey("cache")
                                                                .appendKey("bubble");

    /**
     * 2.0.0以后的气泡任务
     */
    public static KeyGenerator BUBBLE_TASK_V3_CACHE = BASE_KEY.copy()
                                                              .setGroup("task")
                                                              .setKey("cache")
                                                              .appendKey("bubble_v3");

    public static KeyGenerator TODAY_USER_TASK_CACHE = BASE_KEY.copy()
                                                               .setGroup("task")
                                                               .setKey("cache")
                                                               .appendKey("today_task");
}
