package com.bxm.dailyegg.task.evnet;

import com.bxm.component.bus.annotations.EventBusSubscriber;
import com.bxm.component.bus.guava.AllowConcurrentEvents;
import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.event.JoinLotteryEvent;
import com.bxm.dailyegg.common.event.PickEggEvent;
import com.bxm.dailyegg.common.event.PickGrainEvent;
import com.bxm.dailyegg.common.event.SpeedUpEvent;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * 监听任务相关的事件
 *
 * @author liujia
 * @date 2022/04/14 17:48:23
 * @since 2.0.0
 */
@Component
@AllArgsConstructor
public class TaskEventSubscriber {

    private TaskCacheHolder taskCacheHolder;

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void addJoinTimes(JoinLotteryEvent event) {
        taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.JOIN_LOTTERY_V3);
    }

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void pickEgg(PickEggEvent event) {
        taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.PICK_EGG_V3);
    }

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void pickGrain(PickGrainEvent event) {
        taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.PICK_GRAIN_V3);
    }

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void speedUp(SpeedUpEvent event) {
        taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.SPEED_UP_V3);
    }

}
