package com.bxm.dailyegg.task.evnet;

import com.bxm.component.bus.annotations.EventBusSubscriber;
import com.bxm.component.bus.guava.AllowConcurrentEvents;
import com.bxm.dailyegg.common.event.VisitAppEvent;
import com.bxm.dailyegg.task.service.TaskService;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2022/2/22 13:58
 */
@Component
@AllArgsConstructor
public class VisitAppEventSubscriber {

    @Resource
    TaskService taskService;

    @Resource
    UserTaskInfoService userTaskInfoService;

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void openApp(VisitAppEvent event) {
        taskService.visitAppTask(event.getUserId());
    }
}
