package com.bxm.dailyegg.task.facade.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.TaskListItemV2DTO;
import com.bxm.dailyegg.task.service.TaskV3Service;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.dailyegg.user.facade.UserAccountFacadeService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author liujia
 */
@AllArgsConstructor
@Service
@Slf4j
public class TaskConfigFacadeServiceImpl implements TaskConfigFacadeService {

    private UserAccountFacadeService userAccountFacadeService;

    private TaskProperties taskProperties;

    @Override
    public Integer getAwardConfig(Integer totalFoods, TaskActionEnum action) {
        Map<String, List<TaskProperties.TaskAwardConfig>> configMap = taskProperties.getConfigMap();
        List<TaskProperties.TaskAwardConfig> taskAwardConfigs = configMap.get(action.name());
        if (null == taskAwardConfigs) {
            log.error("没有配置[{}]对应的奖励", action);
            return 0;
        }

        Optional<TaskProperties.TaskAwardConfig> matchConfig = taskAwardConfigs.stream().filter(config -> {
            if (null != totalFoods && totalFoods >= 0) {
                return config.getRange().match(totalFoods);
            }
            return false;
        }).findFirst();

        if (matchConfig.isPresent()) {
            return matchConfig.get().getAwardNum();
        }

        log.error("[{}]没有符合条件的配置,用户粮食总数为：{}", action, totalFoods);
        return 0;
    }

    @Override
    public Integer getAwardConfigWithUserId(Long userId, TaskActionEnum taskAction) {
        UserAccountDTO userAccountDTO = userAccountFacadeService.loadUserAccount(userId);
        return getAwardConfig(userAccountDTO.getTotalFoods(), taskAction);
    }

    @Override
    public Integer getAllTaskAwardNum(Long userId) {
        TaskV3Service taskV3Service = SpringContextHolder.getBean(TaskV3Service.class);
        BaseUserParam param = new BaseUserParam();
        param.setUserId(userId);

        List<TaskListItemV2DTO> taskList = taskV3Service.fetchList(param);

        int total = 0;
        for (TaskListItemV2DTO taskItem : taskList) {
            if (taskItem.getManual()) {
                total += taskItem.getAwardGrainNum();
            } else {
                total += taskItem.getAwardGrainNum() * taskItem.getMaxTimes();
            }
        }
        return total;
    }
}
