package com.bxm.dailyegg.task.handler;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.model.bo.UserBubbleTaskContentBO;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lowi
 * @date 2022/2/21 15:35
 */
@Component
public class UserTaskHandlerManage {

    @Resource
    private TaskProperties taskProperties;

    List<UserDailyTaskHandlerService> userDailyTaskHandlerServices;

    List<UserBubbleTaskHandlerService> userBubbleTaskHandlerServices;

    @Autowired
    public UserTaskHandlerManage(List<UserDailyTaskHandlerService> userDailyTaskHandlerServices,
                                 List<UserBubbleTaskHandlerService> userBubbleTaskHandlerServices) {
        this.userDailyTaskHandlerServices = userDailyTaskHandlerServices;
        this.userBubbleTaskHandlerServices = userBubbleTaskHandlerServices;
    }

    public void dailyTaskHandler(UserTaskContentBO userTaskContentBO) {
        if (CollectionUtil.isEmpty(userTaskContentBO.getListItemDTOS())) {
            return;
        }
        if (CollectionUtil.isNotEmpty(userDailyTaskHandlerServices)) {
            for (UserDailyTaskHandlerService taskHandlerService : userDailyTaskHandlerServices) {
                taskHandlerService.handler(userTaskContentBO);
            }
        }
    }

    public void bubbleTaskHandler(UserBubbleTaskContentBO userBubbleTaskContentBO) {
        if (CollectionUtil.isEmpty(userBubbleTaskContentBO.getListItemDTOS())) {
            return;
        }
        if (CollectionUtil.isNotEmpty(userBubbleTaskHandlerServices)) {
            for (UserBubbleTaskHandlerService taskHandlerService : userBubbleTaskHandlerServices) {
                taskHandlerService.handler(userBubbleTaskContentBO);
            }
        }
    }
}
