package com.bxm.dailyegg.task.handler.bubbletask;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserBubbleTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserBubbleTaskContentBO;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemDTO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author lowi
 * @date 2022/2/21 17:53
 */
@Service
@AllArgsConstructor
@Slf4j
public class BubbleTaskVideoHandler implements UserBubbleTaskHandlerService {

    private final UserTaskInfoService userTaskInfoService;

    private final TaskConfigFacadeService taskConfigFacadeService;

    @Override
    public void handler(UserBubbleTaskContentBO userBubbleTaskContentBO) {
        List<BubbleTaskItemDTO> bubbleTaskItemDTOS = userBubbleTaskContentBO.getListItemDTOS();
        BaseUserParam param = userBubbleTaskContentBO.getOriginParam();

        bubbleTaskItemDTOS.removeIf(bubbleTaskItemDTO -> {
            if (userTaskInfoService.bubbleTaskFinish(param.getUserId(), bubbleTaskItemDTO.getTaskId())) {
                return Boolean.TRUE;
            } else {
                Integer userAwardGrainNum = taskConfigFacadeService.getAwardConfig(
                    userBubbleTaskContentBO.getTotalFoods(),
                    TaskActionEnum.valueOf(bubbleTaskItemDTO.getAction())
                );
                bubbleTaskItemDTO.setAwardGrainNum(userAwardGrainNum);
                return Boolean.FALSE;
            }
        });
    }
}
