package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 打开app2次
 *
 * @author lowi
 * @date 2022/2/21 15:15
 */
@Service
@AllArgsConstructor
public class DailyTaskOpenAppTwoHandler implements UserDailyTaskHandlerService {

    private final UserTaskInfoService userTaskInfoService;

    private final TaskConfigFacadeService taskConfigFacadeService;

    private static String SUB_TITLE = "今日打开两次APP,且两次间隔至少10分钟";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();

        List<TaskListItemDTO> listItemDTOS = userTaskContentBO.getListItemDTOS();
        listItemDTOS.forEach(taskListItemDTO -> {
            if (Objects.equals(taskListItemDTO.getAction(), TaskActionEnum.OPEN_APP_TWO.name())) {

                int currentTimes = userTaskInfoService.dailyTaskFinish(
                    originParam.getUserId(),
                    taskListItemDTO.getTaskId()
                ) ? 1 : 0;
                taskListItemDTO.setCurrentTimes(currentTimes);
                Integer awardGrainNum = taskConfigFacadeService.getAwardConfig(
                    userTaskContentBO.getTotalFoods(),
                    TaskActionEnum.OPEN_APP_TWO
                );
                taskListItemDTO.setAwardGrainNum(awardGrainNum);
                taskListItemDTO.setSubTitle(String.format(SUB_TITLE, awardGrainNum));
                taskListItemDTO.setTaskStatus(currentTimes >= taskListItemDTO.getMaxTimes());
                taskListItemDTO.setLookVideo(false);
            }
        });
        userTaskContentBO.setListItemDTOS(listItemDTOS);
    }

}
