package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.integration.AppChnlVersionIntegrationService;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.foundation.base.facade.param.AppVersionParam;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author lowi
 * @date 2022/2/21 15:15
 */
@Service
@AllArgsConstructor
public class DailyTaskSignHandler implements UserDailyTaskHandlerService {

    private final UserTaskInfoService userTaskInfoService;

    private final AppChnlVersionIntegrationService appChnlVersionIntegrationService;

    private TaskConfigFacadeService taskConfigFacadeService;

    private static String SUB_TITLE = "点击签到并观看激励视频,完成后获得%s克粮食";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();
        List<TaskListItemDTO> listItemDTOS = userTaskContentBO.getListItemDTOS();
        listItemDTOS.forEach(taskListItemDTO -> {
            if (Objects.equals(taskListItemDTO.getAction(), TaskActionEnum.SIGN.name())) {
                int currentTimes = userTaskInfoService.getUserDailyTaskFinishNum(
                    originParam.getUserId(),
                    taskListItemDTO.getTaskId()
                );
                taskListItemDTO.setCurrentTimes(currentTimes);

                Integer awardGrainNum = taskConfigFacadeService.getAwardConfig(
                    userTaskContentBO.getTotalFoods(),
                    TaskActionEnum.SIGN
                );
                taskListItemDTO.setAwardGrainNum(awardGrainNum);
                taskListItemDTO.setSubTitle(String.format(SUB_TITLE, awardGrainNum));
                taskListItemDTO.setTaskStatus(currentTimes >= taskListItemDTO.getMaxTimes());

                AppVersionParam appVersionParam = new AppVersionParam();
                appVersionParam.merge(originParam);

                Boolean status = appChnlVersionIntegrationService.getArraignmentStatus(appVersionParam);
                //如果为提神状态,则不用看签到视频
                if (Objects.equals(Boolean.TRUE, status)) {
                    taskListItemDTO.setLookVideo(Boolean.FALSE);
                }
            }
        });
        userTaskContentBO.setListItemDTOS(listItemDTOS);

    }

}
