package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 打开app2次
 *
 * @author lowi
 * @date 2022/2/21 15:15
 */
@Service
@AllArgsConstructor
public class DailyTaskWelfareHandler implements UserDailyTaskHandlerService {

    private final UserTaskInfoService userTaskInfoService;

    private final TaskConfigFacadeService taskConfigFacadeService;

    private static String SUB_TITLE = "每看一个视频可获得%s克粮食,可做10次,累计可获得%s克粮食";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();

        List<TaskListItemDTO> listItemDTOS = userTaskContentBO.getListItemDTOS();
        listItemDTOS.forEach(taskListItemDTO -> {
            if (Objects.equals(taskListItemDTO.getAction(), TaskActionEnum.WELFARE_VIDEO.name())) {
                int currentTimes = userTaskInfoService.getUserDailyTaskFinishNum(
                    originParam.getUserId(),
                    taskListItemDTO.getTaskId()
                );

                Integer awardGrainNum = taskConfigFacadeService.getAwardConfig(
                    userTaskContentBO.getTotalFoods(),
                    TaskActionEnum.WELFARE_VIDEO
                );

                taskListItemDTO.setCurrentTimes(currentTimes);
                taskListItemDTO.setAwardGrainNum(awardGrainNum);
                taskListItemDTO.setSubTitle(
                    String.format(SUB_TITLE, awardGrainNum, (awardGrainNum * taskListItemDTO.getMaxTimes())));
                taskListItemDTO.setTaskStatus(currentTimes >= taskListItemDTO.getMaxTimes());
            }
        });
        userTaskContentBO.setListItemDTOS(listItemDTOS);
    }

}
