package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.bxm.dailyegg.common.constant.TaskCommonConstant.GUIDE_TASK_ID;

/**
 * 在用户任务列表中插入观看引导视频的任务
 *
 * @author liujia
 * @date 2022/03/21 18:26:08
 * @since 1.0.0
 */
@Service
@AllArgsConstructor
public class UserGuideHandler implements UserDailyTaskHandlerService {

    private TaskCacheHolder taskCacheHolder;

    private TaskProperties taskProperties;

    private static String SUB_TITLE = "点击签到并观看激励视频,完成后获得%s克粮食";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();
        if (taskCacheHolder.hasGuideAwardRecord(originParam.getUserId())) {
            return;
        }
        List<TaskListItemDTO> listItemDTOS = userTaskContentBO.getListItemDTOS();

        TaskListItemDTO taskItem = new TaskListItemDTO();
        taskItem.setTaskId(GUIDE_TASK_ID);
        taskItem.setAction(TaskActionEnum.GUIDE_VIDEO.name());
        taskItem.setMaxTimes(1);
        taskItem.setAwardGrainNum(taskProperties.getGuideAwardNum());
        taskItem.setCurrentTimes(0);
        taskItem.setLookVideo(false);
        taskItem.setTitle("观看领蛋秘籍");
        taskItem.setSubTitle("观看领蛋秘籍,获得快速领鸡蛋的窍门,还能获得" + taskItem.getAwardGrainNum() + "克粮食");
        taskItem.setTaskStatus(Boolean.FALSE);
        // 强制排到第二位
        if (listItemDTOS.size() > 0) {
            listItemDTOS.add(1, taskItem);
        } else {
            listItemDTOS.add(taskItem);
        }

        userTaskContentBO.setListItemDTOS(listItemDTOS);
    }

}
