package com.bxm.dailyegg.task.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemDTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.bxm.dailyegg.task.constant.RedisCacheConstant.BUBBLE_TASK_LIST;

/**
 * @author lowi
 * @date 2022/2/23 10:10
 */
@Slf4j
@Service
@AllArgsConstructor
public class TaskCacheRedisRunner implements ApplicationListener {

    private final RedisStringAdapter redisStringAdapter;

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        List<TaskListItemDTO> oldDailyTaskList = redisStringAdapter.get(
            RedisCacheConstant.DAILY_TASK_LIST.copy(),
            new TypeReference<List<TaskListItemDTO>>() {
            }
        );

        if (CollectionUtil.isEmpty(oldDailyTaskList)
            || Objects.isNull(oldDailyTaskList.get(0).getV())
            || oldDailyTaskList.get(0).getV() < TaskListItemDTO.CACHE_VERSION) {
            redisStringAdapter.remove(RedisCacheConstant.DAILY_TASK_LIST.copy());
            loadDailyTask();
        }

        List<BubbleTaskItemDTO> oldBubbleTaskList = redisStringAdapter.get(
            RedisCacheConstant.BUBBLE_TASK_LIST.copy(),
            new TypeReference<List<BubbleTaskItemDTO>>() {
            }
        );

        if (CollectionUtil.isEmpty(oldBubbleTaskList)
            || Objects.isNull(oldBubbleTaskList.get(0).getV())
            || oldBubbleTaskList.get(0).getV() < BubbleTaskItemDTO.CACHE_VERSION) {
            redisStringAdapter.remove(RedisCacheConstant.BUBBLE_TASK_LIST.copy());
            loadBubbleTask();
        }
    }

    private void loadDailyTask() {
        List<TaskListItemDTO> taskListItemDTOS = new ArrayList<>();
        TaskListItemDTO taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("签到");
        taskListItemDTO.setMaxTimes(1);
        taskListItemDTO.setTaskId(1L);
        taskListItemDTO.setAction(TaskActionEnum.SIGN.name());
        taskListItemDTOS.add(taskListItemDTO);

        taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("观看视频");
        taskListItemDTO.setMaxTimes(10);
        taskListItemDTO.setTaskId(2L);
        taskListItemDTO.setAction(TaskActionEnum.VIDEO.name());
        taskListItemDTOS.add(taskListItemDTO);

        taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("观看福利视频");
        taskListItemDTO.setMaxTimes(10);
        taskListItemDTO.setTaskId(3L);
        taskListItemDTO.setAction(TaskActionEnum.WELFARE_VIDEO.name());
        taskListItemDTOS.add(taskListItemDTO);

        taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("打开两次APP");
        taskListItemDTO.setMaxTimes(1);
        taskListItemDTO.setTaskId(4L);
        taskListItemDTO.setAction(TaskActionEnum.OPEN_APP_TWO.name());
        taskListItemDTOS.add(taskListItemDTO);

        redisStringAdapter.set(RedisCacheConstant.DAILY_TASK_LIST.copy(), taskListItemDTOS);
    }

    private void loadBubbleTask() {
        List<BubbleTaskItemDTO> bubbleTaskItemDTOS = new ArrayList<>();
        BubbleTaskItemDTO bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(1L);
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);

        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(2L);
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);

        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(3L);
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);
        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(4L);
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);
        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(5L);
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);

        redisStringAdapter.set(BUBBLE_TASK_LIST.copy(), bubbleTaskItemDTOS);
    }
}
