package com.bxm.dailyegg.task.service;

import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemDTO;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemV2DTO;
import com.bxm.dailyegg.task.model.dto.TaskListDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.newidea.component.bo.Message;

import java.util.List;

/**
 * @author lowi
 * @date 2022/2/21 11:18
 */

public interface TaskService {
    /**
     * 获取用户的气泡任务列表
     *
     * @param param 请求参数
     * @return 列表
     */
    List<BubbleTaskItemDTO> fetchBubbleTaskList(BaseUserParam param);

    /**
     * 获取用户的气泡任务V2版本
     * 用户最多可以有N个气泡任务
     *
     * @param param 参数
     * @return {@link List}<{@link BubbleTaskItemV2DTO}>
     */
    List<BubbleTaskItemV2DTO> fetchBubbleTaskListV2(BaseUserParam param);

    /**
     * 获取用户的任务列表
     *
     * @param param 请求参数
     * @return 任务信息
     */
    TaskListDTO fetchUserTaskList(BaseUserParam param);

    /**
     * 用户完成任务后回调
     *
     * @param param 入参
     * @return 结果
     */
    Message completeTask(CompleteTaskParam param);

    /**
     * 打开app任务
     *
     * @param userId 用户id
     */
    void visitAppTask(Long userId);
}
