package com.bxm.dailyegg.task.service;

import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.model.entity.UserTaskFinishStatisticsEntity;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.dailyegg.user.param.UserAccountOpsParam;
import com.bxm.newidea.component.bo.Message;

import java.util.List;

/**
 * @author lowi
 * @date 2022/2/21 17:18
 */
public interface UserTaskInfoService {

    /**
     * 获取用户日常任务完成次数
     *
     * @param userId 用户id
     * @param taskId 任务id
     * @return 次数
     */
    Integer getUserDailyTaskFinishNum(Long userId, Long taskId);

    /**
     * 气泡任务完成信息
     *
     * @param userId 用户id
     * @param taskId 任务id
     * @return 是否完成
     */
    Boolean bubbleTaskFinish(Long userId, Long taskId);

    /**
     * 日常任务完成信息
     *
     * @param userId 用户id
     * @param taskId 任务id
     * @return 是否完成
     */
    Boolean dailyTaskFinish(Long userId, Long taskId);

    /**
     * 初始化用户任务完成信息
     *
     * @param userId          用户id
     * @param taskListItemDTO 任务列表
     */
    void initUserTaskFinishInfo(Long userId, List<TaskListItemDTO> taskListItemDTO);

    /**
     * 获取用户完成日常任务次数
     *
     * @param userId 用户id
     * @return 统计信息
     */
    UserTaskFinishStatisticsEntity getUserFinishDailyTaskNum(Long userId);

    /**
     * 发送粮食和日志信息
     *
     * @param userAccountOpsParam 入参
     * @return 结果
     */
    Message sendFoodsAndLog(UserAccountOpsParam userAccountOpsParam);

    /**
     * 更新用户额外任务完成次数
     *
     * @param userId  用户id
     * @param currNum 当前次数,防止刷任务
     */
    void updateUserExtFinishNum(Long userId, Integer currNum);

    UserAccountDTO getUserAccountInfo(Long userId);
}
