package com.bxm.dailyegg.task.service.context;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemV2DTO;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
@Builder
public class UserTaskContext {

    private BaseUserParam param;

    private Map<String, UserTaskItemBO> taskCacheMap;

    private List<TaskListItemV2DTO> finalTaskList;

    private UserAccountDTO userAccount;

    private TaskConfigFacadeService configService;

    public Integer getConfigAwardNum(TaskActionEnum action) {
        return configService.getAwardConfig(getTotalFoods(), action);
    }

    public Integer getTotalFoods() {
        return userAccount.getTotalFoods();
    }

    public Long getUserId() {
        return param.getUserId();
    }

    public void addItem(TaskListItemV2DTO item) {
        finalTaskList.add(item);
    }

    public UserTaskItemBO getCacheTaskItem(TaskActionEnum action) {
        return taskCacheMap.getOrDefault(action.name(), new UserTaskItemBO());
    }
}
