package com.bxm.dailyegg.task.service.filter;

import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.constant.LogicConstant;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.service.context.UserTaskContext;
import com.bxm.newidea.component.annotations.LogicFilterBean;
import com.bxm.newidea.component.filter.ILogicFilter;
import com.bxm.newidea.component.filter.LogicFilterChain;
import lombok.AllArgsConstructor;

import java.util.Map;

/**
 * 2.0.0 初始化用户任务缓存
 *
 * @author liujia
 * @date 2022/04/14 15:38:15
 * @since 2.0.0
 */
@LogicFilterBean(group = LogicConstant.USER_TASK_FILTER)
@AllArgsConstructor
public class InitCacheTaskFilter implements ILogicFilter<UserTaskContext> {

    private TaskCacheHolder taskCacheHolder;

    @Override
    public void filter(LogicFilterChain<UserTaskContext> chain, UserTaskContext context) {
        Map<String, UserTaskItemBO> taskCacheMap = context.getTaskCacheMap();
        if (taskCacheMap == null || taskCacheMap.size() == 0) {
            taskCacheMap = taskCacheHolder.initTaskCache(context.getUserId());
            context.setTaskCacheMap(taskCacheMap);
        }

        chain.filter(context);
    }

    @Override
    public int getOrder() {
        return LogicConstant.getOrder(this.getClass());
    }
}
