package com.bxm.dailyegg.task.service.filter;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.constant.LogicConstant;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemV2DTO;
import com.bxm.dailyegg.task.service.context.UserTaskContext;
import com.bxm.newidea.component.annotations.LogicFilterBean;
import com.bxm.newidea.component.filter.ILogicFilter;
import com.bxm.newidea.component.filter.LogicFilterChain;
import lombok.AllArgsConstructor;

/**
 * 2.0.0的签到任务
 *
 * @author liujia
 * @date 2022/04/14 15:38:15
 * @since 2.0.0
 */
@LogicFilterBean(group = LogicConstant.USER_TASK_FILTER)
@AllArgsConstructor
public class SignTaskFilter implements ILogicFilter<UserTaskContext> {

    @Override
    public void filter(LogicFilterChain<UserTaskContext> chain, UserTaskContext context) {
        UserTaskItemBO cacheTaskItem = context.getCacheTaskItem(action());

        TaskListItemV2DTO item = TaskListItemV2DTO.build(cacheTaskItem);
        item.setTitle("签到赚粮食");
        item.setSubTitle("签到观看精彩视频赚粮食,每日" + cacheTaskItem.getMax() + "次");
        item.setAwardGrainNum(context.getConfigAwardNum(action()));
        item.setTaskClickAction("VIDEO");

        context.addItem(item);

        chain.filter(context);
    }

    private TaskActionEnum action() {
        return TaskActionEnum.SIGN_V3;
    }

    @Override
    public int getOrder() {
        return LogicConstant.getOrder(this.getClass());
    }
}
