package com.bxm.dailyegg.task.service.filter;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.constant.LogicConstant;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemV2DTO;
import com.bxm.dailyegg.task.service.context.UserTaskContext;
import com.bxm.newidea.component.annotations.LogicFilterBean;
import com.bxm.newidea.component.filter.ILogicFilter;
import com.bxm.newidea.component.filter.LogicFilterChain;
import lombok.AllArgsConstructor;

/**
 * @author liujia
 * @date 2022/04/14 15:38:15
 * @since 2.0.0
 */
@LogicFilterBean(group = LogicConstant.USER_TASK_FILTER)
@AllArgsConstructor
public class SpeedUpTaskFilter implements ILogicFilter<UserTaskContext> {

    @Override
    public void filter(LogicFilterChain<UserTaskContext> chain, UserTaskContext context) {
        UserTaskItemBO cacheTaskItem = context.getCacheTaskItem(action());
        Integer configAwardNum = context.getConfigAwardNum(action());

        TaskListItemV2DTO item = TaskListItemV2DTO.build(cacheTaskItem);
        item.setTitle("使用加速卡" + cacheTaskItem.getMax() + "次");
        item.setSubTitle("用加速卡给小鸡或者小麦加速,加速" + cacheTaskItem.getMax() + "次后获得" + configAwardNum + "克粮食");
        item.setAwardGrainNum(configAwardNum);
        item.setAction(action().name());

        context.addItem(item);
        chain.filter(context);
    }

    private TaskActionEnum action() {
        return TaskActionEnum.SPEED_UP_V3;
    }

    @Override
    public int getOrder() {
        return LogicConstant.getOrder(this.getClass());
    }
}
