package com.bxm.dailyegg.task.strategy;

import com.bxm.dailyegg.common.config.CommonConfigProperties;
import com.bxm.dailyegg.common.enums.AccountOpsTypeEnum;
import com.bxm.dailyegg.common.enums.FoodsFlowTypeEnum;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.dailyegg.user.param.UserAccountOpsParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @author lowi
 * @date 2022/2/22 10:10
 */
@Slf4j
@Component
public abstract class AbstractUserTaskStrategy implements IUserTaskStrategy {

    @Resource
    private UserTaskInfoService userTaskInfoService;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private TaskProperties taskProperties;

    @Resource
    private CommonConfigProperties commonProperties;

    private TypeReference<List<TaskListItemDTO>> typeReference = new TypeReference<List<TaskListItemDTO>>() {
    };

    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        return Message.build(Boolean.TRUE);
    }

    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {

        return Message.build(Boolean.TRUE);
    }

    public abstract String type();

    @Override
    public Message doTask(CompleteTaskParam completeTaskParam) {
        Message beforeAuthenticationResult = beforeUserTaskAuthentication(completeTaskParam);

        if (!beforeAuthenticationResult.isSuccess()) {
            return beforeAuthenticationResult;
        }

        return afterUserTaskHandler(completeTaskParam);
    }

    protected Message sendFoods(Long userId, Integer foodsNum, String remark) {
        UserAccountOpsParam param = new UserAccountOpsParam();
        param.setUserId(userId);
        param.setNum(foodsNum);
        param.setOpsType(AccountOpsTypeEnum.ADD_FOOD);
        param.setFlowTypeEnum(FoodsFlowTypeEnum.ADD_FOODS);
        param.setRemark(remark);
        return userTaskInfoService.sendFoodsAndLog(param);
    }

    protected TaskListItemDTO getTaskInfo(String action) {
        List<TaskListItemDTO> taskListItemList = redisStringAdapter.get(
            RedisCacheConstant.DAILY_TASK_LIST.copy(), typeReference
        );

        Optional<TaskListItemDTO> taskListItem = taskListItemList.stream()
                                                                 .filter(taskListItemDTO ->
                                                                             taskListItemDTO.getAction()
                                                                                            .equals(action))
                                                                 .findFirst();

        return taskListItem.orElse(null);
    }

    protected KeyGenerator builderDailyTaskKey(Long userId) {
        String date = DateUtils.formatDate(new Date());
        return RedisCacheConstant.USER_DAILY_TASK_NUM.copy().appendKey(userId).appendKey(date);
    }

    protected KeyGenerator builderUserDailyTaskFinishInfo(Long userId) {
        String date = DateUtils.formatDate(new Date());
        return RedisCacheConstant.USER_DAILY_TASK_FINISH_INFO.copy().appendKey(userId).appendKey(date);
    }

    protected KeyGenerator builderBubbleTaskKey(Long userId) {
        String date = DateUtils.formatDate(new Date());
        return RedisCacheConstant.USER_BUBBLE_TASK_NUM.copy().appendKey(userId).appendKey(date);
    }

    /**
     * 判断用户获取到奖励以后是否需要显示临界值
     *
     * @param param      完成任务的参数
     * @param accountDTO 用户账号信息
     * @param taskDTO    任务完成结果信息
     */
    protected void hasAd(CompleteTaskParam param, UserAccountDTO accountDTO, CompleteTaskDTO taskDTO) {
        if (accountDTO == null) {
            accountDTO = userTaskInfoService.getUserAccountInfo(param.getUserId());
        }

        if (null != taskDTO) {
            taskDTO.setShowAd(accountDTO.getTotalFoods() > commonProperties.getShowAdCriticalValue());
        }
    }

    /**
     * V1.4.0 去除完成所有任务的额外奖励
     *
     * @param userId
     */
    protected void extTaskReward(Long userId) {
        //        List<Boolean> values = redisHashMapAdapter.values(builderUserDailyTaskFinishInfo(userId), Boolean.class);
        //
        //        if (CollectionUtil.isEmpty(values)) {
        //            return;
        //        }
        //
        //        if (values.contains(Boolean.FALSE)) {
        //            return;
        //        }
        //        UserTaskFinishStatisticsEntity userFinishDailyTaskNum = userTaskInfoService.getUserFinishDailyTaskNum(userId);
        //
        //        Integer rewardEggNum = null;
        //        Map<String, Integer> extFinishTaskReward = taskProperties.getExtFinishTaskReward();
        //        if (Objects.isNull(extFinishTaskReward)) {
        //            return;
        //        } else {
        //            int num = userFinishDailyTaskNum == null ? 1 : userFinishDailyTaskNum.getNum() + 1;
        //
        //            rewardEggNum = extFinishTaskReward.get(Integer.toString(num));
        //            if (Objects.isNull(rewardEggNum)) {
        //                return;
        //            }
        //        }

        //        if (Objects.nonNull(userFinishDailyTaskNum)) {
        //            Date modifyTime = userFinishDailyTaskNum.getModifyTime();
        //            boolean sameDay = DateUtil.isSameDay(modifyTime, new Date());
        //            //今天更新过,则不再更新
        //            if (sameDay) {
        //                return;
        //            }
        //        }

        //        UserAccountOpsParam param = new UserAccountOpsParam();
        //        param.setUserId(userId);
        //        param.setNum(rewardEggNum);
        //        param.setOpsType(AccountOpsTypeEnum.ADD_EGG);
        //        param.setEggFlowTypeEnum(EggFlowTypeEnum.ADD_EGG);
        //        param.setRemark("完成所有任务额外获得" + rewardEggNum + "枚蛋");
        //        Message message = userTaskInfoService.sendFoodsAndLog(param);
        //
        //        if (message.isSuccess()) {
        //            userTaskInfoService.updateUserExtFinishNum(
        //                    userId, userFinishDailyTaskNum == null ? null : userFinishDailyTaskNum.getNum());
        //        }
    }

}
