package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author liujia
 * @date 2022/04/14 15:08:27
 * @since 2.0.0
 */
@Slf4j
public abstract class AbstractSingleTaskV3ActionStrategy extends AbstractUserTaskStrategy {

    @Resource
    private TaskCacheHolder taskCacheHolder;

    @Resource
    private UserTaskInfoService userTaskInfoService;

    @Resource
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam param) {
        Map<String, UserTaskItemBO> cacheTaskMap = taskCacheHolder.fetchUserTask(param.getUserId());

        UserTaskItemBO cacheTaskItem = cacheTaskMap.get(getAction().name());
        if (null == cacheTaskItem) {
            log.error("任务不存在,无法完成,请求信息：{}", JSON.toJSONString(param));
            return Message.build(false, "任务不存在");
        }

        if (cacheTaskItem.getCurrent() >= cacheTaskItem.getMax()) {
            return Message.build(false, "已达到今日任务数量上限");
        }

        return Message.build();
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam param) {
        UserAccountDTO userAccountInfo = userTaskInfoService.getUserAccountInfo(param.getUserId());
        Integer userAwardGrainNum = taskConfigFacadeService.getAwardConfig(
            userAccountInfo.getTotalFoods(),
            getAction()
        );
        Message message = sendFoods(param.getUserId(), userAwardGrainNum, flowRemark());

        if (!message.isSuccess()) {
            return message;
        }

        taskCacheHolder.addTaskTimes(param.getUserId(), getAction());

        CompleteTaskDTO responseTask = new CompleteTaskDTO();
        responseTask.setAwardNum(userAwardGrainNum);
        hasAd(param, userAccountInfo, responseTask);

        return Message.build().addParam("resultDTO", responseTask);
    }

    protected abstract TaskActionEnum getAction();

    protected abstract String flowRemark();

    @Override
    public String type() {
        return getAction().name();
    }

}
