package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author lowi
 * @date 2022/2/22 10:14
 */
@Service
@Slf4j
@AllArgsConstructor
public class BubbleVideoTaskActionStrategy extends AbstractUserTaskStrategy {

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final UserTaskInfoService userTaskInfoService;

    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        KeyGenerator key = builderBubbleTaskKey(completeTaskParam.getUserId());
        Integer currNum = redisHashMapAdapter.get(
            key,
            completeTaskParam.getTaskId().toString(),
            Integer.class
        );

        if (Objects.nonNull(currNum) && currNum >= 1) {
            return Message.build(Boolean.FALSE).setMessage("此气泡任务已完成");
        }
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        UserAccountDTO userAccountInfo = userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        //获取用户应该获取多少g粮食
        Integer userAwardGrainNum = taskConfigFacadeService.getAwardConfig(
            userAccountInfo.getTotalFoods(),
            TaskActionEnum.BUBBLE_VIDEO
        );

        Message message = sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "气泡任务奖励");

        if (!message.isSuccess()) {
            return message;
        }

        //增加签到次数
        KeyGenerator key = builderBubbleTaskKey(completeTaskParam.getUserId());
        redisHashMapAdapter.put(
            key,
            completeTaskParam.getTaskId().toString(),
            1
        );
        redisHashMapAdapter.expire(key, DateUtils.getCurSeconds());

        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setAwardNum(userAwardGrainNum);

        return Message.build().addParam("resultDTO", completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.BUBBLE_VIDEO.name();
    }

}
