package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 基于缓存的气泡任务
 *
 * @author liujia
 * @date 2022/03/31 17:52:03
 * @since 1.3.0
 */
@Service
@Slf4j
@AllArgsConstructor
public class BubbleVideoTaskDirectActionStrategy extends AbstractUserTaskStrategy {

    private final TaskCacheHolder taskCacheHolder;

    private final TaskProperties taskProperties;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Integer todayBubbleTaskNum = taskCacheHolder.getTodayBubbleTaskNum(completeTaskParam.getUserId());
        if (todayBubbleTaskNum >= taskProperties.getMaxBubbleTaskNum()) {
            log.error("用户[{}]完成了超出数量的气泡任务,请检查是否有逻辑问题", completeTaskParam.getUserId());
            return Message.build(false, "已达到今日任务数量上限");
        }
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        Message message = sendFoods(completeTaskParam.getUserId(), 1, "气泡任务奖励");

        if (!message.isSuccess()) {
            return message;
        }

        // 增加气泡任务使用数量
        taskCacheHolder.addUserBubbleTask(completeTaskParam.getUserId());

        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setAwardNum(1);

        hasAd(completeTaskParam, null, completeTaskDTO);

        return Message.build().addParam("resultDTO", completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.BUBBLE_VIDEO_DIRECT.name();
    }

}
