package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 2.0.0 看视频的气泡任务
 *
 * @author liujia
 * @date 2022/04/14 15:08:27
 * @since 2.0.0
 */
@Service
@Slf4j
@AllArgsConstructor
public class BubbleVideoTaskV3ActionStrategy extends AbstractUserTaskStrategy {

    private final TaskCacheHolder taskCacheHolder;

    private final TaskProperties taskProperties;

    private final UserTaskInfoService userTaskInfoService;

    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Map<String, Integer> todayBubbleV3 = taskCacheHolder.getTodayBubbleV3(completeTaskParam.getUserId());
        int todayNum = todayBubbleV3.getOrDefault(getAction().name(), 0);

        if (todayNum >= taskProperties.getMaxVideoBubble()) {
            log.error("用户[{}]完成了超出数量的气泡任务,请检查是否有逻辑问题", completeTaskParam.getUserId());
            return Message.build(false, "已达到今日任务数量上限");
        }
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam param) {
        //获取用户应该获取多少g粮食
        UserAccountDTO userAccountInfo = userTaskInfoService.getUserAccountInfo(param.getUserId());
        Integer userAwardGrainNum = taskConfigFacadeService.getAwardConfig(
            userAccountInfo.getTotalFoods(),
            getAction()
        );
        Message message = sendFoods(param.getUserId(), userAwardGrainNum, "视频气泡任务奖励");

        if (!message.isSuccess()) {
            return message;
        }

        // 增加气泡任务使用数量
        taskCacheHolder.addTodayBubbleV3Times(param.getUserId(), getAction());

        CompleteTaskDTO responseTask = new CompleteTaskDTO();
        responseTask.setAwardNum(userAwardGrainNum);
        hasAd(param, userAccountInfo, responseTask);

        return Message.build().addParam("resultDTO", responseTask);
    }

    private TaskActionEnum getAction() {
        return TaskActionEnum.BUBBLE_VIDEO_V3;
    }

    @Override
    public String type() {
        return getAction().name();
    }

}
