package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 额外获取粮食奖励
 *
 * @author liujia
 * @date 2022/03/31 17:52:03
 * @since 1.3.0
 */
@Service
@Slf4j
@AllArgsConstructor
public class ExtGrantGiftActionStrategy extends AbstractUserTaskStrategy {

    private final TaskProperties taskProperties;

    private final UserTaskInfoService userTaskInfoService;

    private final TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        Integer awardNum = taskConfigFacadeService.getAwardConfigWithUserId(
            completeTaskParam.getUserId(),
            TaskActionEnum.EXT_GRANT_GIFT_REWARD
        );

        Message message = sendFoods(
            completeTaskParam.getUserId(),
            awardNum,
            "神秘礼包粮食奖励"
        );

        if (!message.isSuccess()) {
            return message;
        }

        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setAwardNum(awardNum);

        return Message.build().addParam("resultDTO", completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.EXT_GRANT_GIFT_REWARD.name();
    }

}
