package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2022/2/22 10:14
 */
@Service
@Slf4j
@AllArgsConstructor
public class ExtRewardTaskActionStrategy extends AbstractUserTaskStrategy {

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {

        Message message = sendFoods(completeTaskParam.getUserId(), 5, "签到额外奖励");

        if (!message.isSuccess()) {
            return message;
        }

        Message build = Message.build();
        build.setSuccess(Boolean.TRUE);
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("领取成功");
        completeTaskDTO.setAwardNum(5);
        build.addParam("resultDTO", completeTaskDTO);
        return build;
    }

    @Override
    public String type() {
        return TaskActionEnum.EXT_VIDEO_REWARD.name();
    }

}
