package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 用户完成新人引导视频后的回调
 *
 * @author liujia
 * @date 2022/03/21 18:42:48
 * @since 1.0.0
 */
@Service
@Slf4j
@AllArgsConstructor
public class GuideTaskActionStrategy extends AbstractUserTaskStrategy {

    private TaskProperties taskProperties;

    private TaskCacheHolder taskCacheHolder;

    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        if (taskCacheHolder.hasGuideAwardRecord(completeTaskParam.getUserId())) {
            return Message.build(false, "已经发放过观看领蛋秘籍的奖励");
        }
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        //获取用户应该获取多少g粮食
        Integer userAwardGrainNum = taskProperties.getGuideAwardNum();

        Message message = sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "观看领蛋秘籍");

        if (!message.isSuccess()) {
            return message;
        }

        // 记录已经发放过奖励
        taskCacheHolder.addGuideAwardRecord(completeTaskParam.getUserId());

        //把当天任务置为完成
        redisHashMapAdapter.put(builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()),
                                completeTaskParam.getTaskId().toString(), Boolean.TRUE
        );

        extTaskReward(completeTaskParam.getUserId());

        Message build = Message.build();
        build.setSuccess(Boolean.TRUE);
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("任务完成");
        completeTaskDTO.setAwardNum(userAwardGrainNum);

        build.addParam("resultDTO", completeTaskDTO);
        return build;
    }

    @Override
    public String type() {
        return TaskActionEnum.GUIDE_VIDEO.name();
    }

}
