package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2022/2/22 10:14
 */
@Service
@Slf4j
@AllArgsConstructor
public class OpenAppTwoTaskActionStrategy extends AbstractUserTaskStrategy {

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final RedisStringAdapter redisStringAdapter;

    private final UserTaskInfoService userTaskInfoService;

    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {

        Integer time = redisStringAdapter.get(builderUserOpenAppTime(completeTaskParam.getUserId()), Integer.class);

        if (Objects.nonNull(time)) {
            return Message.build(Boolean.FALSE).setMessage("此任务,两次间隔至少10分钟");
        }
        //增加次数
        redisHashMapAdapter.increment(
            builderDailyTaskKey(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), 1);
        redisHashMapAdapter.expire(builderDailyTaskKey(completeTaskParam.getUserId()), DateUtils.getCurSeconds());

        redisStringAdapter.set(builderUserOpenAppTime(completeTaskParam.getUserId()), 1);
        redisStringAdapter.expire(builderUserOpenAppTime(completeTaskParam.getUserId()), 10 * 60);

        Long taskId = completeTaskParam.getTaskId();
        Integer openAppNum = userTaskInfoService.getUserDailyTaskFinishNum(completeTaskParam.getUserId(), taskId);

        if (openAppNum > 2) {
            return Message.build(Boolean.FALSE).setMessage("此任务已完成,请勿重复点击");
        }

        if (openAppNum < 2) {
            return Message.build(Boolean.FALSE).setMessage("此任务已未完成,请勿重复点击");
        }

        return Message.build(Boolean.TRUE);
    }

    private KeyGenerator builderUserOpenAppTime(Long userId) {
        String date = DateUtils.formatDate(new Date());
        return RedisCacheConstant.USER_OPEN_APP_TIME.copy().appendKey(userId).appendKey(date);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {

        UserAccountDTO userAccountInfo = userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        //获取用户应该获取多少g粮食
        Integer userAwardGrainNum = taskConfigFacadeService.getAwardConfig(
            userAccountInfo.getTotalFoods(), TaskActionEnum.OPEN_APP_TWO);

        Message message = sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "打开两次APP奖励");

        if (!message.isSuccess()) {
            return message;
        }

        //把当天任务置为完成
        redisHashMapAdapter.put(builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()),
                                completeTaskParam.getTaskId().toString(), Boolean.TRUE
        );

        extTaskReward(completeTaskParam.getUserId());

        Message build = Message.build();
        build.setSuccess(Boolean.TRUE);
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("领取成功");
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        build.addParam("resultDTO", completeTaskDTO);
        return build;
    }

    @Override
    public String type() {
        return TaskActionEnum.OPEN_APP_TWO.name();
    }

}
